import motor
import time
import random


def goto(m: motor.Motor, x, vel, accel):
    # print(m.get_states())
    m.set_target_position(x, vel, accel)

    # print(m.get_states())
    # ... wait while not at point:
    while True:
        states = m.get_states()

        # print(states["position"])
        # if states['is_moving'] == 0:
        if not states["is_moving"]:
            break
        # if abs(states["position"] - x) <= 0.01:
        #     break


def goto_all(m1: motor.Motor, m2: motor.Motor, x1, x2, vel, accel):
    m1.set_target_position(x1, vel, accel)
    m2.set_target_position(x2, vel, accel)

    # ... wait while not at point:
    done = False
    while not done:
        states1 = m1.get_states()
        states2 = m2.get_states()
        done = states1['is_moving'] == 0 and states2['is_moving'] == 0


def main():
    # change to the correct serial port
    m = motor.Motor("COM47")

    # turns/sec
    vel = 5
    # turns/sec²
    acc = 30

    # 200 steps per turn
    steps_per_unit = 200
    # 30% current
    current = 0.3

    m.set_steps_per_unit(steps_per_unit)
    m.set_current(current)

    goto(m, 2.0, vel, acc)
    time.sleep(0.2)
    goto(m, 0.0, vel, acc)

    m.set_current(0)


if __name__ == "__main__":
    main()
