import tkinter as tk
from PIL import Image, ImageTk
from functools import partial
import RPi.GPIO as GPIO

# GPIO pin mapping
PINS = {
    "B1": 14,  # bottle 1
    "B2": 15,  # bottle 2
    "B3": 18,  # bottle 3
    "B4": 17,  # bottle 4
    "B5": 27,  # bottle 5
    "B6": 22,  # bottle 6
    "PUMP": 25 # pump
}

# States and button references
state = {key: False for key in PINS}
buttons = {}

# Setup GPIO
GPIO.setmode(GPIO.BCM)
for pin in PINS.values():
    GPIO.setup(pin, GPIO.OUT)

# Functions
def button_touch(pin_key):
    pin = PINS[pin_key]
    if state[pin_key]:
        GPIO.output(pin, False)
        state[pin_key] = False
        buttons[pin_key].config(bg="#cc3300")  # OFF = red
    else:
        GPIO.output(pin, True)
        state[pin_key] = True
        buttons[pin_key].config(bg="#00cc66")  # ON = green

def pump(pin_key):
    pump_pin = PINS[pin_key]
    GPIO.output(pump_pin, True)

    def stop_all():
        for key, pin in PINS.items():
            GPIO.output(pin, False)
            state[key] = False
            if key in buttons:
                buttons[key].config(bg="#cc3300")  # reset to OFF/red

    window.after(5000, stop_all)  # 5 seconds later

# Create main window
window = tk.Tk()
window.title("GPIO CONTROL")
window.geometry("600x400")

def exit_fullscreen(event=None):
    window.attributes("-fullscreen", False)

window.bind("<Escape>", exit_fullscreen)

screen_width = window.winfo_screenwidth()
screen_height = window.winfo_screenheight()

# Load and place background image
bg_image = Image.open("background.jpg").resize((screen_width, screen_height))
bg_photo = ImageTk.PhotoImage(bg_image)
bg_label = tk.Label(window, image=bg_photo)
bg_label.place(x=0, y=0, relwidth=1, relheight=1)

# Title
title_label = tk.Label(window, text="LET'S MIX", font=("Arial", 24), fg="white", bg="#1e1e1e")
title_label.place(relx=0.5, y=20, anchor="n")

# Row 1
row1 = tk.Frame(window, bg="", bd=0, highlightthickness=0)
row1.place(relx=0.5, y=80, anchor="n")

buttons["B6"] = tk.Button(row1, text="6", width=10, height=2, font=("Arial", 14),
                          bg="#cc3300", fg="white", command=partial(button_touch, "B6"))
buttons["B6"].pack(side="left", padx=5)

buttons["B5"] = tk.Button(row1, text="5", width=10, height=2, font=("Arial", 14),
                          bg="#cc3300", fg="white", command=partial(button_touch, "B5"))
buttons["B5"].pack(side="left", padx=5)

buttons["B4"] = tk.Button(row1, text="4", width=10, height=2, font=("Arial", 14),
                          bg="#cc3300", fg="white", command=partial(button_touch, "B4"))
buttons["B4"].pack(side="left", padx=5)

# Row 2
row2 = tk.Frame(window, bg="", bd=0, highlightthickness=0)
row2.place(relx=0.5, y=160, anchor="n")

buttons["B3"] = tk.Button(row2, text="3", width=10, height=2, font=("Arial", 14),
                          bg="#cc3300", fg="white", command=partial(button_touch, "B3"))
buttons["B3"].pack(side="left", padx=5)

buttons["B2"] = tk.Button(row2, text="2", width=10, height=2, font=("Arial", 14),
                          bg="#cc3300", fg="white", command=partial(button_touch, "B2"))
buttons["B2"].pack(side="left", padx=5)

buttons["B1"] = tk.Button(row2, text="1", width=10, height=2, font=("Arial", 14),
                          bg="#cc3300", fg="white", command=partial(button_touch, "B1"))
buttons["B1"].pack(side="left", padx=5)

# START button
tk.Button(window, text="START", font=("Arial", 16),
          bg="#444444", fg="white", command=partial(pump, "PUMP")).place(relx=0.5, rely=0.9, anchor="s")

# Main loop
window.mainloop()

# GPIO cleanup
GPIO.cleanup()
